/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.client.persisted;

import com.cobblemon.mod.common.config.CobblemonConfig;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_2960;
import net.minecraft.class_5498;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002!\"B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\f\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\r\u0010\u000e\u001a\u00020\b\u00a2\u0006\u0004\b\u000e\u0010\u0003R\u001f\u0010\u0011\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000f8\u0006\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014R\u001f\u0010\u0016\u001a\n \u0010*\u0004\u0018\u00010\u00150\u00158\u0006\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019R\u001f\u0010\u001a\u001a\n \u0010*\u0004\u0018\u00010\u00150\u00158\u0006\u00a2\u0006\f\n\u0004\b\u001a\u0010\u0017\u001a\u0004\b\u001b\u0010\u0019R\"\u0010\u001c\u001a\u00020\u000b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\r\"\u0004\b\u001f\u0010 \u00a8\u0006#"}, d2={"Lcom/cobblemon/mod/common/client/persisted/ClientPersistedData;", "", "<init>", "()V", "Lcom/cobblemon/mod/common/client/persisted/ClientPersistedData$SnapshotAcknowledgementData;", "readSnapshotsData", "()Lcom/cobblemon/mod/common/client/persisted/ClientPersistedData$SnapshotAcknowledgementData;", "data", "", "writeSnapshotsData", "(Lcom/cobblemon/mod/common/client/persisted/ClientPersistedData$SnapshotAcknowledgementData;)V", "Lcom/cobblemon/mod/common/client/persisted/ClientPersistedData$RidingPerspectiveData;", "readRidingPerspectivesData", "()Lcom/cobblemon/mod/common/client/persisted/ClientPersistedData$RidingPerspectiveData;", "saveRidingPerspectivesData", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "gson", "Lcom/google/gson/Gson;", "getGson", "()Lcom/google/gson/Gson;", "Ljava/nio/file/Path;", "snapshotsPath", "Ljava/nio/file/Path;", "getSnapshotsPath", "()Ljava/nio/file/Path;", "ridingPerspectivesPath", "getRidingPerspectivesPath", "ridingPerspectives", "Lcom/cobblemon/mod/common/client/persisted/ClientPersistedData$RidingPerspectiveData;", "getRidingPerspectives", "setRidingPerspectives", "(Lcom/cobblemon/mod/common/client/persisted/ClientPersistedData$RidingPerspectiveData;)V", "SnapshotAcknowledgementData", "RidingPerspectiveData", "common"})
@SourceDebugExtension(value={"SMAP\nClientPersistedData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClientPersistedData.kt\ncom/cobblemon/mod/common/client/persisted/ClientPersistedData\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,70:1\n1#2:71\n*E\n"})
public final class ClientPersistedData {
    @NotNull
    public static final ClientPersistedData INSTANCE = new ClientPersistedData();
    private static final Gson gson = CobblemonConfig.Companion.getGSON();
    private static final Path snapshotsPath = Paths.get("cobblemon", new String[0]).resolve("snapshots.json");
    private static final Path ridingPerspectivesPath = Paths.get("cobblemon", new String[0]).resolve("riding_perspectives.json");
    @NotNull
    private static RidingPerspectiveData ridingPerspectives;

    private ClientPersistedData() {
    }

    public final Gson getGson() {
        return gson;
    }

    public final Path getSnapshotsPath() {
        return snapshotsPath;
    }

    public final Path getRidingPerspectivesPath() {
        return ridingPerspectivesPath;
    }

    @NotNull
    public final RidingPerspectiveData getRidingPerspectives() {
        return ridingPerspectives;
    }

    public final void setRidingPerspectives(@NotNull RidingPerspectiveData ridingPerspectiveData) {
        Intrinsics.checkNotNullParameter((Object)ridingPerspectiveData, (String)"<set-?>");
        ridingPerspectives = ridingPerspectiveData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final SnapshotAcknowledgementData readSnapshotsData() {
        Path path = snapshotsPath;
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"snapshotsPath");
        Object object = path;
        Object object2 = new LinkOption[]{};
        if (Files.exists((Path)object, Arrays.copyOf(object2, ((LinkOption[])object2).length))) {
            object = new BufferedReader(new InputStreamReader(new FileInputStream(snapshotsPath.toFile())));
            object2 = null;
            try {
                BufferedReader reader = (BufferedReader)object;
                boolean bl = false;
                SnapshotAcknowledgementData snapshotAcknowledgementData = (SnapshotAcknowledgementData)gson.fromJson((Reader)reader, SnapshotAcknowledgementData.class);
                return snapshotAcknowledgementData;
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeSnapshotsData(@NotNull SnapshotAcknowledgementData data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        snapshotsPath.toFile().getParentFile().mkdirs();
        Closeable closeable = new BufferedWriter(new FileWriter(snapshotsPath.toFile()));
        Throwable throwable = null;
        try {
            BufferedWriter writer = (BufferedWriter)closeable;
            boolean bl = false;
            gson.toJson((Object)data, (Appendable)writer);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final RidingPerspectiveData readRidingPerspectivesData() {
        Path path = ridingPerspectivesPath;
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"ridingPerspectivesPath");
        Object object = path;
        Object object2 = new LinkOption[]{};
        if (Files.exists((Path)object, Arrays.copyOf(object2, ((LinkOption[])object2).length))) {
            object = new BufferedReader(new InputStreamReader(new FileInputStream(ridingPerspectivesPath.toFile())));
            object2 = null;
            try {
                BufferedReader reader = (BufferedReader)object;
                boolean bl = false;
                RidingPerspectiveData ridingPerspectiveData = (RidingPerspectiveData)gson.fromJson((Reader)reader, RidingPerspectiveData.class);
                return ridingPerspectiveData;
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void saveRidingPerspectivesData() {
        ridingPerspectivesPath.toFile().getParentFile().mkdirs();
        Closeable closeable = new BufferedWriter(new FileWriter(ridingPerspectivesPath.toFile()));
        Throwable throwable = null;
        try {
            BufferedWriter writer = (BufferedWriter)closeable;
            boolean bl = false;
            gson.toJson((Object)ridingPerspectives, (Appendable)writer);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    static {
        RidingPerspectiveData ridingPerspectiveData = INSTANCE.readRidingPerspectivesData();
        if (ridingPerspectiveData == null) {
            ridingPerspectiveData = new RidingPerspectiveData(null, 1, null);
        }
        ridingPerspectives = ridingPerspectiveData;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001d\u0010\u000b\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001c\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ&\u0010\u000f\u001a\u00020\u00002\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001a\u0010\u0013\u001a\u00020\u00122\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010\u0016\u001a\u00020\u0015H\u00d6\u0001\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0010\u0010\u0019\u001a\u00020\u0018H\u00d6\u0001\u00a2\u0006\u0004\b\u0019\u0010\u001aR#\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001b\u001a\u0004\b\u001c\u0010\u000e\u00a8\u0006\u001d"}, d2={"Lcom/cobblemon/mod/common/client/persisted/ClientPersistedData$RidingPerspectiveData;", "", "", "Lnet/minecraft/class_2960;", "Lnet/minecraft/class_5498;", "perspectives", "<init>", "(Ljava/util/Map;)V", "key", "cameraType", "", "updatePerspective", "(Lnet/minecraft/class_2960;Lnet/minecraft/class_5498;)V", "component1", "()Ljava/util/Map;", "copy", "(Ljava/util/Map;)Lcom/cobblemon/mod/common/client/persisted/ClientPersistedData$RidingPerspectiveData;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Ljava/util/Map;", "getPerspectives", "common"})
    public static final class RidingPerspectiveData {
        @NotNull
        private final Map<class_2960, class_5498> perspectives;

        public RidingPerspectiveData(@NotNull Map<class_2960, class_5498> perspectives) {
            Intrinsics.checkNotNullParameter(perspectives, (String)"perspectives");
            this.perspectives = perspectives;
        }

        public /* synthetic */ RidingPerspectiveData(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = new LinkedHashMap();
            }
            this(map);
        }

        @NotNull
        public final Map<class_2960, class_5498> getPerspectives() {
            return this.perspectives;
        }

        public final void updatePerspective(@NotNull class_2960 key, @NotNull class_5498 cameraType) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)cameraType, (String)"cameraType");
            this.perspectives.put(key, cameraType);
            INSTANCE.saveRidingPerspectivesData();
        }

        @NotNull
        public final Map<class_2960, class_5498> component1() {
            return this.perspectives;
        }

        @NotNull
        public final RidingPerspectiveData copy(@NotNull Map<class_2960, class_5498> perspectives) {
            Intrinsics.checkNotNullParameter(perspectives, (String)"perspectives");
            return new RidingPerspectiveData(perspectives);
        }

        public static /* synthetic */ RidingPerspectiveData copy$default(RidingPerspectiveData ridingPerspectiveData, Map map, int n, Object object) {
            if ((n & 1) != 0) {
                map = ridingPerspectiveData.perspectives;
            }
            return ridingPerspectiveData.copy(map);
        }

        @NotNull
        public String toString() {
            return "RidingPerspectiveData(perspectives=" + this.perspectives + ")";
        }

        public int hashCode() {
            return ((Object)this.perspectives).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RidingPerspectiveData)) {
                return false;
            }
            RidingPerspectiveData ridingPerspectiveData = (RidingPerspectiveData)other;
            return Intrinsics.areEqual(this.perspectives, ridingPerspectiveData.perspectives);
        }

        public RidingPerspectiveData() {
            this(null, 1, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\b\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ$\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u0004H\u00c6\u0001\u00a2\u0006\u0004\b\f\u0010\rJ\u001a\u0010\u000f\u001a\u00020\u00042\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010\u0012\u001a\u00020\u0011H\u00d6\u0001\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u0014\u0010\tR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0015\u001a\u0004\b\u0016\u0010\tR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0017\u001a\u0004\b\u0018\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lcom/cobblemon/mod/common/client/persisted/ClientPersistedData$SnapshotAcknowledgementData;", "", "", "version", "", "dontShowAgain", "<init>", "(Ljava/lang/String;Z)V", "component1", "()Ljava/lang/String;", "component2", "()Z", "copy", "(Ljava/lang/String;Z)Lcom/cobblemon/mod/common/client/persisted/ClientPersistedData$SnapshotAcknowledgementData;", "other", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "toString", "Ljava/lang/String;", "getVersion", "Z", "getDontShowAgain", "common"})
    public static final class SnapshotAcknowledgementData {
        @NotNull
        private final String version;
        private final boolean dontShowAgain;

        public SnapshotAcknowledgementData(@NotNull String version, boolean dontShowAgain) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            this.version = version;
            this.dontShowAgain = dontShowAgain;
        }

        @NotNull
        public final String getVersion() {
            return this.version;
        }

        public final boolean getDontShowAgain() {
            return this.dontShowAgain;
        }

        @NotNull
        public final String component1() {
            return this.version;
        }

        public final boolean component2() {
            return this.dontShowAgain;
        }

        @NotNull
        public final SnapshotAcknowledgementData copy(@NotNull String version, boolean dontShowAgain) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            return new SnapshotAcknowledgementData(version, dontShowAgain);
        }

        public static /* synthetic */ SnapshotAcknowledgementData copy$default(SnapshotAcknowledgementData snapshotAcknowledgementData, String string, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                string = snapshotAcknowledgementData.version;
            }
            if ((n & 2) != 0) {
                bl = snapshotAcknowledgementData.dontShowAgain;
            }
            return snapshotAcknowledgementData.copy(string, bl);
        }

        @NotNull
        public String toString() {
            return "SnapshotAcknowledgementData(version=" + this.version + ", dontShowAgain=" + this.dontShowAgain + ")";
        }

        public int hashCode() {
            int result = this.version.hashCode();
            result = result * 31 + Boolean.hashCode(this.dontShowAgain);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SnapshotAcknowledgementData)) {
                return false;
            }
            SnapshotAcknowledgementData snapshotAcknowledgementData = (SnapshotAcknowledgementData)other;
            if (!Intrinsics.areEqual((Object)this.version, (Object)snapshotAcknowledgementData.version)) {
                return false;
            }
            return this.dontShowAgain == snapshotAcknowledgementData.dontShowAgain;
        }
    }
}

